<?php

use Tygh\Shippings\RealtimeServices;

require_once dirname(__FILE__) . '/../../TestUnitDB.php';

class RealtimeServicesTest extends TestUnitDB
{

    public $location = array(
        'country' => "US",
        'state' => "MA",
        'city' => "Boston",
        'zipcode' => "02125",
        'address' => "Boston street",
        'address_2' => false,
        'phone' => "8(800)-000-00-00",
        'address_type' => "residential",
        'firstname' => "John",
        'lastname' => "Doe",
    );

    /**
     * @dataProvider dpRegister
     */
    public function testRegister($shipping_key, $shipping_info, $expected, $expectedRates)
    {
        // Remove this code after the test is fixed
        $this->markTestSkipped(
            'This test is probably malfunctioning'
        );

        RealtimeServices::clearStack();

        $actual = RealtimeServices::register($shipping_key, $shipping_info);
        $this->assertEquals($expected, $actual);

        $actual = RealtimeServices::getRates();
        if (isset($expectedRates[0]['price']) && isset($actual[0]['price'])) {
            $this->assertEquals(gettype($expectedRates[0]['price']), gettype($actual[0]['price']));
            unset($expectedRates[0]['price']);
            unset($actual[0]['price']);
        }
        $this->assertEquals($expectedRates, $actual);
    }

    public function dpRegister()
    {
        $packages = array(
            'C' => 729.99,
            'W' => 20.00,
            'I' => 2,
            'packages' => array (
                0 => array (
                    'shipping_params' => array (
                        'min_items_in_box' => 1,
                        'max_items_in_box' => 5,
                        'box_length' => 145,
                        'box_width' => 12,
                        'box_height' => 34,
                    ),
                    'products' => array (
                        '4088798008' => 1,
                    ),
                    'amount' => 1,
                    'weight' => 20,
                    'cost' => 699.99,
                ),
                1 => array (
                    'shipping_params' => array (
                        'min_items_in_box' => 1,
                        'max_items_in_box' => 2,
                        'box_length' => 12,
                        'box_width' => 32,
                        'box_height' => 12,
                    ),
                    'products' => array (
                        '822274303' => 1,
                    ),
                    'amount' => 1,
                    'weight' => 0.1,
                    'cost' => 30,
                ),
            ),
            'origination' => array (
                'name' => "Simtech",
                'address' => "44 Main street",
                'city' => "Boston",
                'country' => "US",
                'state' => "MA",
                'zipcode' => '02116',
                'phone' => '8(800)-000-00-00',
                'fax' => false,
            ),
            'location' => $this->location,
        );

        $shipping_list = array(
            0 => array(
                'shipping_id' => 1,
                'shipping' => "Custom shipping method",
                'delivery_time' => "3-5 days",
                'destination' => 'I',
                'min_weight' => 0.00,
                'max_weight' => 0.00,
                'rate_calculation' => 'M',
                'service_id' => 0,
                'module' => '',
                'service_params' => array(),
                'package_info' => array(
                    'W' => '0.01',
                    'C' => '100',
                    'I' => '1',
                    'origination' => array(
                        'name' => 'Simtech',
                        'address' => '44 Main street',
                        'city' => 'Boston',
                        'country' => 'RU',
                        'state' => 'CHE',
                        'zipcode' => '431645',
                        'phone' => '8(800)-000-00-00',
                        'fax' => '',
                    ),
                    'location' => array(
                        'address' => 'Boston street',
                        'zipcode' => '02125',
                        'city' => 'Boston',
                        'country' => 'US',
                        'state' => 'MA',
                        'phone' => '8(800)-000-00-00',
                        'address_type' => 'residential',
                        'firstname' => 'John',
                        'lastname' => 'Doe',
                    ),
                ),
            ),
            1 => array(
                'shipping_id' => 3,
                'shipping' => "FedEx 2nd day",
                'delivery_time' => "2 days",
                'destination' => 'I',
                'min_weight' => 0.00,
                'max_weight' => 0.00,
                'rate_calculation' => 'R',
                'service_id' => 213,
                'module' => 'fedex',
                'service_code' => 'FEDEX_2_DAY',
                'service_params' => array(
                    'user_key' => 'JAHR7R8oMgMFRH55',
                    'user_key_password' => 'YxIJQaZt7Qx3Qt904ibYPhuDa',
                    'account_number' => '510087089',
                    'meter_number' => '118530569',
                    'test_mode' => 'Y',
                    'package_type' => 'FEDEX_BOX',
                    'drop_off_type' => 'REGULAR_PICKUP',
                    'max_weight_of_box' => 0,
                    'height' => 10,
                    'width' => 10,
                    'length' => 10,
                ),
                'rate_info' => array(
                    'rate_id' => 46,
                    'rate_value' => array(
                        'C' => array(
                            0 => array(
                                'value' => 10.00,
                                'type' => 'P',
                            ),
                        ),
                    ),
                ),
                'package_info' => $packages,
            ),
            2 => array(
                'shipping_id' => 3,
                'shipping' => "FedEx 2nd day",
                'delivery_time' => "2 days",
                'destination' => 'I',
                'min_weight' => 0.00,
                'max_weight' => 0.00,
                'rate_calculation' => 'R',
                'service_id' => 213,
                'module' => 'fedex',
                'service_code' => 'FEDEX_2_DAY',
                'service_params' => array(
                    'user_key' => '',
                    'user_key_password' => '',
                    'account_number' => '',
                    'meter_number' => '',
                    'test_mode' => 'Y',
                    'package_type' => 'FEDEX_BOX',
                    'drop_off_type' => 'REGULAR_PICKUP',
                    'max_weight_of_box' => 0,
                    'height' => 10,
                    'width' => 10,
                    'length' => 10,
                ),
                'rate_info' => array(
                    'rate_id' => 46,
                    'rate_value' => array(
                        'C' => array(
                            0 => array(
                                'value' => 10.00,
                                'type' => 'P',
                            ),
                        ),
                    ),
                ),
                'package_info' => $packages,
            ),
        );

        return array(
            array(
                1, $shipping_list[0],
                __('shippings.service_not_configured'),
                array(),
            ),
            array(
                1, $shipping_list[1],
                '',
                array(
                    0 => array(
                        'price' => '51.41',
                        'shipping_key' => 1,
                        'error' => false
                    ),
                ),
            ),
            array(
                1, $shipping_list[2],
                '',
                array(
                    0 => array(
                        'price' => false,
                        'shipping_key' => 1,
                        'error' => 'ERROR 1000 Authentication Failed'
                    ),
                ),
            ),
        );
    }

}
