<?php

namespace Tygh\Api\Entities;

require_once dirname(__FILE__) . '/../../../TestUnitDB.php';

use Tygh\Api\Entities\Orders;
use Tygh\Api\Response;
use Tygh\Registry;
/**
 * Tests core API functionality via CURL
 */
class OrdersTest extends \TestUnitDB
{
    /**
     * @var \Tygh\Api\Entities\Orders
     */
    protected $api_order;

    protected function setUp()
    {   
        parent::setUp();

        $this->api_order = new Orders(array(
            'area' => 'A',
            'user_id' => '1',
            'user_type' => 'A',
            'tax_exempt' => 'N',
            'last_login' => '1343637055',
            'usergroup_ids' => array ( ),
            'order_ids' => array ( ),
            'act_as_user' => false,
            'this_login' => 1343652763,
            'password_change_timestamp' => 0,
            'company_id' => 0,
            'is_root' => 'Y',
            'referer' => '',
            'ip' => '192.168.1.111',
            'first_expire_check' => false
        ));

    }

    protected function tearDown()
    {
    }

    public static function setUpBeforeClass()
    {
        \Tygh\Registry::set('runtime.company_id', 0);
    }

    protected function taxesDatset()
    {
        return array(
            'orders.xml',
            'order_data.xml',
            'order_details.xml',
            //'users.xml',
            'payments.xml',
            'payment_processors.xml',
            'payment_descriptions.xml',

        );
    }

    /**
     *
     * @dataProvider providerIndex()
     * @datasetProvider taxesDatset
     */
    public function testIndex($id, $params, $result)
    {
        $this->markTestSkipped('TEMP');
        //print_r(fn_array2code_string($this->_obejct->index($id, $params)));
        //print_r($this->api_order->index(38, $params)); exit;
        $this->assertEquals($result, $this->api_order->index($id, $params));
    }

    public function providerIndex()
    {
        return array(
            // Get taxes list
            array('', array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'orders' => array(
                        array(
                            'order_id' => 39,
                            'issuer_id' => '',
                            'user_id' => 3,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523775,
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'status' => 'O',
                            'total' => 5427.99,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                        array(
                            'order_id' => 38,
                            'issuer_id' => '',
                            'user_id' => 1,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523773,
                            'firstname' => 'John',
                            'lastname' => 'Doe',
                            'email' => 'admin@example.com',
                            'status' => 'C',
                            'total' => 118.00,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                        array(
                            'order_id' => 37,
                            'issuer_id' => '',
                            'user_id' => 3,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523698,
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'status' => 'F',
                            'total' => 93.00,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                        array(
                            'order_id' => 36,
                            'issuer_id' => '',
                            'user_id' => 3,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523638,
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'status' => 'O',
                            'total' => 118.00,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                        array(
                            'order_id' => 35,
                            'issuer_id' => '',
                            'user_id' => 3,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523563,
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'status' => 'I',
                            'total' => 727.99,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                        array(
                            'order_id' => 34,
                            'issuer_id' => '',
                            'user_id' => 3,
                            'is_parent_order' => 'N',
                            'parent_order_id' => 0,
                            'company_id' => 0,
                            'timestamp' => 1354523490,
                            'firstname' => 'Customer',
                            'lastname' => 'Customer',
                            'email' => 'customer@example.com',
                            'status' => 'C',
                            'total' => 10827.98,
                            'invoice_id' => '',
                            'credit_memo_id' => '',
                            'phone' => '',
                        ),
                    ),

                    'params' => array(
                        'page' => 1,
                        'items_per_page' => '10',
                        'include_incompleted' => false,
                        'sort_order' => 'desc',
                        'sort_by' => 'date',
                        'sort_order_rev' => 'asc',
                        'total_items' => 6,
                    ),
                ),
            )),

            // Get taxes list
            array(38, array(), array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'order_id' => '38',
                    'is_parent_order' => 'N',
                    'parent_order_id' => '0',
                    'company_id' => '0',
                    'issuer_id' => null,
                    'user_id' => '1',
                    'total' => '118.00',
                    'subtotal' => 90.0,
                    'discount' => '0.00',
                    'subtotal_discount' => '0.00',
                    'payment_surcharge' => '0.00',
                    'shipping_ids' => '1',
                    'shipping_cost' => '28.00',
                    'timestamp' => '1354523773',
                    'status' => 'C',
                    'notes' => '',
                    'details' => '',
                    'promotions' => array(),
                    'promotion_ids' => '',
                    'firstname' => 'John',
                    'lastname' => 'Doe',
                    'company' => '',
                    'b_firstname' => 'John',
                    'b_lastname' => 'Doe',
                    'b_address' => '44 Main street',
                    'b_address_2' => 'test',
                    'b_city' => 'Boston',
                    'b_county' => '',
                    'b_state' => 'MA',
                    'b_country' => 'US',
                    'b_zipcode' => '02134',
                    'b_phone' => '',
                    's_firstname' => 'John',
                    's_lastname' => 'Doe',
                    's_address' => '44 Main street',
                    's_address_2' => '',
                    's_city' => 'Boston',
                    's_county' => '',
                    's_state' => 'MA',
                    's_country' => 'US',
                    's_zipcode' => '02134',
                    's_phone' => '',
                    's_address_type' => '',
                    'phone' => '',
                    'fax' => '',
                    'url' => '',
                    'email' => 'admin@example.com',
                    'payment_id' => '2',
                    'tax_exempt' => 'N',
                    'lang_code' => 'en',
                    'ip_address' => '10.7.7.91',
                    'repaid' => '0',
                    'validation_code' => '',
                    'localization_id' => '0',
                    'payment_method' => array(
                        'payment_id' => 2,
                        'company_id' => 0,
                        'usergroup_ids' => 0,
                        'position' => 20,
                        'status' => 'A',
                        'template' => 'phone.tpl',
                        'processor_id' => 0,
                        'processor_params' => '',
                        'a_surcharge' => 0.000,
                        'p_surcharge' => 0.000,
                        'tax_ids' => array(),
                        'localization' => '',
                        'payment_category' => 'tab3',
                        'payment' => 'Phone ordering',
                        'description' => 'Call to 5555555',
                        'instructions' => 'Type instructions to pay by visiting your retail store in here.',
                        'surcharge_title' => '',
                        'lang_code' => 'en',
                        'processor' => null,
                        'processor_type' => null,
                        'image' => array(),
                    ),
                    'fields' => array(),
                    'products' => array(
                        '822274303' => array(
                            'item_id' => 822274303,
                            'order_id' => '38',
                            'product_id' => '12',
                            'product_code' => 'U0012O5AF0',
                            'price' => '30.00',
                            'amount' => '3',
                            'extra' => array(
                                'product_options' => array(
                                    '4' => 17,
                                    '3' => 12,
                                ),
                                'unlimited_download' => 'N',
                                'product' => '100g Pants',
                                'company_id' => 0,
                                'is_edp' => 'N',
                                'edp_shipping' => 'N',
                                'discount' => 0,
                                'base_price' => 30,
                                'stored_price' => 'N',
                                'product_options_value' => array(
                                    '0' => array(
                                        'option_id' => 4,
                                        'product_id' => 12,
                                        'company_id' => 0,
                                        'option_type' => 'S',
                                        'inventory' => 'Y',
                                        'regexp' => '',
                                        'required' => 'N',
                                        'multiupload' => 'N',
                                        'allowed_extensions' => '',
                                        'max_file_size' => 0,
                                        'missing_variants_handling' => 'M',
                                        'status' => 'A',
                                        'position' => 0,
                                        'value' => 17,
                                        'option_name' => 'Color',
                                        'option_text' => '',
                                        'description' => '',
                                        'inner_hint' => '',
                                        'incorrect_message' => '',
                                        'modifier' => 0.000,
                                        'modifier_type' => 'A',
                                        'variant_name' => 'Black/White/White',
                                    ),
                                    '1' => array(
                                        'option_id' => 3,
                                        'product_id' => 12,
                                        'company_id' => 0,
                                        'option_type' => 'S',
                                        'inventory' => 'Y',
                                        'regexp' => '',
                                        'required' => 'N',
                                        'multiupload' => 'N',
                                        'allowed_extensions' => '',
                                        'max_file_size' => 0,
                                        'missing_variants_handling' => 'M',
                                        'status' => 'A',
                                        'position' => 10,
                                        'value' => 12,
                                        'option_name' => 'Size',
                                        'option_text' => 'Size',
                                        'description' => '',
                                        'inner_hint' => '',
                                        'incorrect_message' => '',
                                        'modifier' => 0.000,
                                        'modifier_type' => 'A',
                                        'variant_name' => 'Small',
                                    ),
                                ),
                            ),
                            'product' => '100g Pants',
                            'product_status' => 'A',
                            'deleted_product' => false,
                            'discount' => 0,
                            'company_id' => 0,
                            'base_price' => 30.0,
                            'original_price' => 30.0,
                            'cart_id' => 822274303,
                            'tax_value' => 0,
                            'subtotal' => 90,
                            'display_subtotal' => 90,
                            'shipped_amount' => 0,
                            'shipment_amount' => 3,
                            'is_accessible' => true,
                            'shared_product' => false,
                        ),
                    ),
                    'taxes' => array(
                        '6' => array(
                            'rate_type' => 'P',
                            'rate_value' => 10.000,
                            'price_includes_tax' => 'Y',
                            'regnumber' => 1234242,
                            'priority' => 0,
                            'tax_subtotal' => 10.73,
                            'description' => 'VAT',
                            'applies' => array(
                                'P' => 8.18,
                                'S' => 2.55,
                            ),
                        ),
                    ),
                    'tax_subtotal' => 0,
                    'display_shipping_cost' => '28.00',
                    'is_root' => '',
                    'birthday' => '',
                    'purchase_timestamp_from' => '',
                    'purchase_timestamp_to' => '',
                    'responsible_email' => '',
                    'last_passwords' => '',
                    'password_change_timestamp' => '',
                    'api_key' => '',
                    'b_country_descr' => 'United States',
                    's_country_descr' => 'United States',
                    'b_state_descr' => 'Massachusetts',
                    's_state_descr' => 'Massachusetts',
                    'need_shipping' => true,
                    'shipment_ids' => array(),
                    'secondary_currency' => 'USD',
                    'display_subtotal' => 90.0,
                    'payment_info' => array(),
                    'shipping' => array(
                        array(
                            'need_shipment' => true
                        ),
                        array(
                            'shipping' => 'Custom shipping method',
                            'rates' => array(
                                '0' => 28,
                            ),
                            'packages_info' => array(
                                'C' => 90,
                                'W' => 0.01,
                                'I' => 3,
                                'origination' => array(
                                    'name' => 'Simtech',
                                    'address' => '44 Main street',
                                    'city' => 'Boston',
                                    'country' => 'US',
                                    'state' => 'MA',
                                    'zipcode' => '02116',
                                    'phone' => '8(800)-000-00-00',
                                    'fax' => '',
                                ),
                            ),
                        ),
                    ),
                    'doc_ids' => array(),
                    'profile_id' => '0'
                ),
            ))
        );
    }

    /**
     *
     * @dataProvider providerCreate()
     * @datasetProvider taxesDatset
     */
    public function testCreate($params, $result)
    {
        $this->markTestSkipped('TEMP');
        Registry::set('runtime.company_id', 2);
        $actual = $this->api_order->create($params);

        $this->assertEquals($result, $actual);

        if ($actual['status'] == Response::STATUS_CREATED) {
            //$this->assertEquals($update_order, fn_get_order_info($actual['data']['order_id']));
        }
    }

    public function providerCreate()
    {
        return array(
            // Try create with empty data
            array(array(), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'user_id/user_data'))
                ),
            )),
            // Try create without user data
            array(array(
                'payment_id' => 2,
                'products' => array(
                    '148' => array(
                        'amount' => 1
                    ),
                ),
            ), array(
                'status' => Response::STATUS_BAD_REQUEST,
                'data' => array(
                    'message' => __('api_required_field', array('[field]' => 'user_id/user_data'))
                ),
            )),
            // Try create
            array(array(
                'payment_id' => 2,
                'user_id' => 3,
                'products' => array(
                    '12' => array(
                        'amount' => 1
                    ),
                ),
            ), array(
                'status' => Response::STATUS_CREATED,
                'data' => array(
                    'order_id' => 40,
                ),
            )),
            // Try create without user_id
            array(array(
                'payment_id' => 2,
                'user_data' => array(
                    'email' => 'test@example.com',

                    'firstname' => 'first',
                    'lastname' => 'last',

                    'b_firstname' => 'first',
                    'b_lastname' => 'last',
                    'b_address' => 'adress',
                    'b_city' => 'city',
                    'b_country' => 'US',
                    'b_state' => 'AL',
                    'b_zipcode' => 12345,

                    's_firstname' => 'first',
                    's_lastname' => 'last',
                    's_address' => 'adress',
                    's_city' => 'city',
                    's_country' => 'US',
                    's_state' => 'AL',
                    's_zipcode' => 12345,
                    's_phone' => '8(800)-000-00-00',
                ),
                'products' => array(
                    '12' => array(
                        'amount' => 1
                    ),
                ),
            ), array(
                'status' => Response::STATUS_CREATED,
                'data' => array(
                    'order_id' => 40,
                ),
            )),
        );
    }

    /**
     *
     * @dataProvider providerUpdate()
     */
    public function testUpdate($id, $params, $update_order, $result)
    {
        $this->markTestSkipped('TEMP');
        Registry::set('runtime.company_id', 2);
        $actual = $this->api_order->update($id, $params);
        $this->assertEquals($result, $actual);

        if ($actual['status'] == Response::STATUS_OK) {
            $order_info = array_intersect_key(fn_get_order_info($actual['data']['order_id']), $update_order);
            $this->assertEquals($update_order, $order_info);
        }
    }

    public function providerUpdate()
    {
        $orders = array(
            array(
                'b_lastname' => 'test_lastname',
                'lastname' => 'last',
                'payment_id' => '1',
                'payment_info' => array('cardholder_name' => 'test'),
                'timestamp' => TIME,
            ),

            array(
                'payment_id' => '3',
                'payment_info' => array(
                    'customer_signature' => '1',
                    'checking_account_number' => '2',
                ),
                'payment_method' => fn_get_payment_method_data(3),
                'timestamp' => TIME,
            ),
        );

        return array(
            // update with empty id
            array('',
                array(
                    'tax' => 'test',
                    'regnumber' => '321',
                ),
                array(),
                array(
                    'status' => Response::STATUS_BAD_REQUEST,
                    'data' => array(),
                )
            ),

            // Try update
            array(40,
                array(
                    'payment_id' => '1',
                    'payment_info' => array(
                        'cardholder_name' => 'test',
                    ),
                    'b_lastname' => 'test_lastname',
                    'firstname' => 'test_firstname',
                ),
                $orders[0],
                array(
                    'status' => Response::STATUS_OK,
                    'data' => array(
                        'order_id' => 40,
                    )
                )
            ),

            // Try update
            array(40,
                array(
                    'payment_id' => '3',
                    'payment_info' => array(
                        'customer_signature' => '1',
                        'checking_account_number' => '2'
                    ),
                ),
                $orders[1],
                array(
                    'status' => Response::STATUS_OK,
                    'data' => array(
                        'order_id' => 40,
                    )
                )
            ),
        );
    }

    /**
     *
     * @dataProvider providerDelete()
     */
    public function testDelete($id, $result)
    {
        $this->markTestSkipped('TEMP');
        $actual = $this->api_order->delete($id);
        $this->assertEquals($result, $actual);

        if ($actual['status'] == Response::STATUS_NO_CONTENT) {
            $actual = $this->api_order->delete($id);
            $this->assertEquals($actual, array('status' => Response::STATUS_NOT_FOUND));
        }

    }

    public function providerDelete()
    {
        return array(
            // Try delete with empty id
            array('', array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete with nonexistent id
            array(777, array(
                'status' => Response::STATUS_NOT_FOUND,
                'data' => array(),
            )),
            // Try delete
            array(40, array(
                'status' => Response::STATUS_OK,
                'data' => array(
                    'message' => 'Ok'
                ),
            )),
        );
    }
}
